﻿using Percent___Qualification_work.Classes;
using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace Percent___Qualification_work.userControls
{
    public partial class gList : UserControl
    {
        private List<DataRow> gamesList = new List<DataRow>();
        private int currentPage = 1;
        private const int GamesPerPage = 10;
        public gList()
        {
            InitializeComponent();
            LoadGames();
        }
        private void LoadGames()
        {
            DataTable gamesTable = DatabaseConnection.Instance.GetUserGames(Authentication.ActiveUserID);
            gamesList = gamesTable.AsEnumerable().ToList();
            DisplayGames();
        }

        private void DisplayGames()
        {
            int startIndex = (currentPage - 1) * GamesPerPage;
            int endIndex = Math.Min(startIndex + GamesPerPage, gamesList.Count);

            // Create and add a card for each plan in the current page
            for (int i = startIndex; i < endIndex; i++)
            {
                DataRow game = gamesList[i];
                Panel planCard = CreateGameCard(game);
                flowLayoutPanel1.Controls.Add(planCard);
            }
            UpdatePaginator();
        }
        private Panel CreateGameCard(DataRow game)
        {
            // Create card panel
            Panel card = new Panel
            {
                BorderStyle = BorderStyle.FixedSingle,
                Size = new Size(100, 150), // Card size
                Margin = new Padding(10)
            };

            //Game image
            PictureBox pictureBox = new PictureBox
            {
                SizeMode = PictureBoxSizeMode.StretchImage,
                Size = new Size(100, 130), // Adjust size as needed
                Location = new Point(0, 0)
            };

            // Check if the "CoverImage" column contains valid data
            if (game["CoverImage"] is byte[] imageData)
            {
                MessageBox.Show(imageData.ToString());
                pictureBox.Image = ConvertBytesToImage(imageData);
            }

            // Game name label
            Label nameLabel = new Label
            {
                Text = game["GameName"].ToString(),
                Font = new Font("Arial", 10, FontStyle.Bold),
                AutoSize = true,
                Location = new Point(20, 130)
            };

            card.Controls.Add(nameLabel);
            return card;
        }
        private void UpdatePaginator()
        {
            prevButton.Enabled = currentPage > 1;
            nextButton.Enabled = currentPage * GamesPerPage < gamesList.Count;
            pageLabel.Text = $"Page {currentPage} of {Math.Ceiling((double)gamesList.Count / GamesPerPage)}";
        }

        private Image ConvertBytesToImage(byte[] imageData)
        {
            using (var ms = new System.IO.MemoryStream(imageData))
            {
                return Image.FromStream(ms);
            }
        }
    }
}
